<?php

namespace App\Http\Controllers;

use App\Models\Tip;
use App\Models\MissingPerson;
use Illuminate\Http\Request;

class TipController extends Controller
{
    public function store(Request $request, $missingPersonId)
    {
        $validated = $request->validate([
            'message' => 'required|string',
            'contact_info' => 'nullable|string',
            'evidence' => 'nullable|file|mimes:jpg,jpeg,png,pdf|max:5120',
        ]);

        $validated['missing_person_id'] = $missingPersonId;

        if ($request->hasFile('evidence')) {
            $validated['evidence'] = $request->file('evidence')->store('evidence', 'public');
        }

        Tip::create($validated);

        return redirect()->back()
                         ->with('success', 'Your information has been sent to the reporter securely. Thank you for helping!');
    }
}
