<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('missing_persons', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            
            // Reporter Information
            $table->string('relation');
            $table->string('reporter_contact');
            $table->string('reporter_city');
            $table->string('reporter_state');
            
            // Missing Person Details
            $table->string('name');
            $table->integer('age');
            $table->enum('gender', ['Male', 'Female', 'Other']);
            $table->string('height')->nullable();
            $table->string('complexion')->nullable();
            $table->string('language')->nullable();
            $table->date('date_missing');
            $table->string('last_seen_location');
            $table->text('medical_condition')->nullable();
            
            // Identification
            $table->string('photo');
            $table->string('fir_copy');
            $table->string('identification_marks')->nullable();
            $table->string('clothes')->nullable();
            
            // Status
            $table->enum('status', ['Active', 'Resolved', 'Pending Verification'])->default('Pending Verification');
            $table->boolean('is_verified')->default(false);
            
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('missing_persons');
    }
};
