<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('missing_persons', function (Blueprint $table) {
            if (!Schema::hasColumn('missing_persons', 'fir_status')) {
                $table->string('fir_status')->default('Pending')->after('fir_copy'); // Pending, Verified, Rejected
            }
            if (!Schema::hasColumn('missing_persons', 'verification_remarks')) {
                $table->text('verification_remarks')->nullable()->after('fir_status');
            }
            if (!Schema::hasColumn('missing_persons', 'deleted_at')) {
                $table->softDeletes();
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('missing_persons', function (Blueprint $table) {
            $table->dropColumn(['fir_status', 'verification_remarks']);
            $table->dropSoftDeletes();
        });
    }
};
