<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Clear existing test users to prevent unique constraint errors
        User::whereIn('email', ['test@example.com', 'admin@example.com'])->delete();

        // Test Regular User
        User::create([
            'name' => 'Test User',
            'email' => 'test@example.com',
            'mobile' => '9876543210',
            'password' => \Illuminate\Support\Facades\Hash::make('password'),
            'is_admin' => false,
        ]);

        // Test Admin User
        User::create([
            'name' => 'System Admin',
            'email' => 'admin@example.com',
            'mobile' => '9999999999',
            'password' => \Illuminate\Support\Facades\Hash::make('password'),
            'is_admin' => true,
        ]);
    }
}
