@extends('layouts.admin')

@section('admin_content')
<div class="row mb-4">
    <div class="col-8">
        <h4 class="fw-800 mb-0">Messages Monitoring</h4>
        <p class="text-muted small">Monitor tips and communications sent by finders.</p>
    </div>
</div>

<div class="table-card">
    <div class="table-responsive">
        <table class="table mb-0 align-middle">
            <thead>
                <tr>
                    <th class="ps-4">Sender / Contact</th>
                    <th>Linked Case</th>
                    <th>Message Content</th>
                    <th>Date / Time</th>
                    <th class="text-end pe-4">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($messages as $msg)
                <tr>
                    <td class="ps-4">
                        <div class="fw-700 text-dark small">Unknown Finder</div>
                        <div class="extra-small text-muted">{{ $msg->contact_info ?? 'No Phone' }}</div>
                    </td>
                    <td>
                        <a href="{{ route('admin.reports.show', $msg->missing_person_id) }}" class="text-decoration-none">
                            <span class="badge bg-light text-primary border rounded-pill extra-small">
                                {{ $msg->missingPerson->name }}
                            </span>
                        </a>
                    </td>
                    <td>
                        <div class="p-3 bg-light rounded-3 small text-dark border-start border-4 border-info">
                            {{ $msg->message }}
                        </div>
                    </td>
                    <td>
                        <div class="extra-small text-muted">{{ $msg->created_at->format('M d, H:i') }}</div>
                    </td>
                    <td class="text-end pe-4">
                        <div class="d-flex justify-content-end gap-2">
                            <form action="{{ route('admin.messages.destroy', $msg->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-light-danger btn-sm rounded-pill p-2 border-0 bg-danger-soft" style="width: 32px; height: 32px;" title="Flag & Delete" onclick="return confirm('Spam detected? Delete message?')">
                                    <i class="fa-solid fa-trash-can text-danger"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" class="text-center py-5 text-muted small">No new tips/messages found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    <div class="card-footer bg-white py-3">
        {{ $messages->links() }}
    </div>
</div>

<style>
    .extra-small { font-size: 0.72rem; }
    .bg-danger-soft { background: rgba(239, 68, 68, 0.1); }
</style>
@endsection
