@extends('layouts.admin')

@section('admin_content')
<div class="row align-items-center mb-4">
    <div class="col-md-6">
        <h4 class="fw-800 mb-0">Reports Management</h4>
        <p class="text-muted small">Monitor and verify missing person cases.</p>
    </div>
    <div class="col-md-6 text-md-end">
        <form class="d-flex justify-content-md-end gap-2" method="GET">
            <input type="text" name="search" class="form-control form-control-sm rounded-pill px-3 shadow-sm border-0" placeholder="Search case name..." value="{{ request('search') }}">
            <select name="status" class="form-select form-select-sm rounded-pill px-3 shadow-sm border-0" onchange="this.form.submit()">
                <option value="">All Status</option>
                <option value="Active" {{ request('status') == 'Active' ? 'selected' : '' }}>Active</option>
                <option value="Resolved" {{ request('status') == 'Resolved' ? 'selected' : '' }}>Resolved</option>
                <option value="Found" {{ request('status') == 'Found' ? 'selected' : '' }}>Found</option>
            </select>
        </form>
    </div>
</div>

<div class="table-card">
    <div class="table-responsive">
        <table class="table mb-0 align-middle">
            <thead>
                <tr>
                    <th class="ps-4">Case ID</th>
                    <th>Missing Person</th>
                    <th>City / State</th>
                    <th>Reporter</th>
                    <th>FIR Status</th>
                    <th>Progress</th>
                    <th class="text-end pe-4">Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($reports as $report)
                <tr>
                    <td class="ps-4">
                        <span class="fw-700 text-primary small">#CASE{{ str_pad($report->id, 5, '0', STR_PAD_LEFT) }}</span>
                    </td>
                    <td>
                        <div class="d-flex align-items-center">
                            <img src="{{ asset('storage/' . $report->photo) }}" class="rounded shadow-sm me-2" style="width: 35px; height: 35px; object-fit: cover;">
                            <div class="fw-600 text-dark small">{{ $report->name }}</div>
                        </div>
                    </td>
                    <td>
                        <div class="small fw-500 text-dark">{{ $report->last_seen_location }}</div>
                        <div class="extra-small text-muted">{{ $report->date_missing->format('d M Y') }}</div>
                    </td>
                    <td>
                        <div class="small fw-500 text-dark">{{ $report->user->name }}</div>
                        <div class="extra-small text-muted">{{ $report->reporter_contact }}</div>
                    </td>
                    <td>
                        @if($report->fir_status == 'Verified')
                            <span class="badge bg-success bg-opacity-10 text-success rounded-pill extra-small px-3">Verified</span>
                        @elseif($report->fir_status == 'Rejected')
                            <span class="badge bg-danger bg-opacity-10 text-danger rounded-pill extra-small px-3">Rejected</span>
                        @else
                            <span class="badge bg-warning bg-opacity-10 text-dark rounded-pill extra-small px-3">Pending</span>
                        @endif
                    </td>
                    <td>
                         @if($report->status == 'Active')
                            <span class="badge border border-success text-success rounded-pill extra-small px-2">Live Search</span>
                         @elseif($report->status == 'Resolved' || $report->status == 'Found')
                            <span class="badge bg-success text-white rounded-pill extra-small px-2">Resolved</span>
                         @else
                            <span class="badge bg-light text-muted rounded-pill extra-small px-2">Hold</span>
                         @endif
                    </td>
                    <td class="text-end pe-4">
                        <div class="btn-group shadow-sm rounded-pill overflow-hidden border bg-white">
                            <a href="{{ route('admin.reports.show', $report->id) }}" class="btn btn-white btn-sm border-0 px-3" title="Review & Verify">
                                <i class="fa-solid fa-file-shield text-info"></i>
                            </a>
                            <form action="{{ route('admin.reports.destroy', $report->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-white btn-sm border-0 px-3" title="Soft Delete" onclick="return confirm('Archive this report?')">
                                    <i class="fa-solid fa-trash-can text-danger"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <div class="card-footer bg-white py-3">
        {{ $reports->links() }}
    </div>
</div>

<style>
    .extra-small { font-size: 0.72rem; }
</style>
@endsection
