@extends('layouts.admin')

@section('admin_content')
<div class="row mb-4 align-items-center">
    <div class="col-8">
        <a href="{{ route('admin.reports.index') }}" class="text-decoration-none small text-muted mb-2 d-block"><i class="fa-solid fa-arrow-left"></i> Back to List</a>
        <h4 class="fw-800 mb-0">Case Review: {{ $report->name }}</h4>
    </div>
    <div class="col-4 text-end">
        <span class="badge {{ $report->fir_status == 'Verified' ? 'bg-success' : 'bg-warning' }} px-3 py-2 rounded-3">
            FIR Status: {{ $report->fir_status }}
        </span>
    </div>
</div>

<div class="row g-4">
    <!-- Main Report Data -->
    <div class="col-lg-8">
        <div class="card border-0 shadow-sm rounded-4 mb-4 overflow-hidden">
            <div class="card-header bg-white py-3">
                <h6 class="fw-800 mb-0">Detailed Information</h6>
            </div>
            <div class="card-body p-4">
                <div class="row g-4">
                    <div class="col-md-4 text-center">
                         <img src="{{ asset('storage/' . $report->photo) }}" class="img-fluid rounded-4 shadow-sm mb-3" style="max-height: 250px; width: 100%; object-fit: cover;">
                         <div class="p-2 bg-light rounded-3 small">
                             <div class="fw-700 text-dark">Age: {{ $report->age }} | {{ $report->gender }}</div>
                         </div>
                    </div>
                    <div class="col-md-8">
                         <div class="row g-3">
                             <div class="col-6">
                                 <label class="text-muted extra-small text-uppercase fw-700">Last Seen</label>
                                 <p class="small fw-600 text-dark">{{ $report->last_seen_location }}</p>
                             </div>
                             <div class="col-6">
                                 <label class="text-muted extra-small text-uppercase fw-700">Date Missing</label>
                                 <p class="small fw-600 text-dark">{{ $report->date_missing->format('d M, Y') }}</p>
                             </div>
                             <div class="col-6">
                                 <label class="text-muted extra-small text-uppercase fw-700">Reporter Name</label>
                                 <p class="small fw-600 text-dark">{{ $report->user->name }}</p>
                             </div>
                             <div class="col-6">
                                 <label class="text-muted extra-small text-uppercase fw-700">Relation</label>
                                 <p class="small fw-600 text-dark">{{ $report->relation }}</p>
                             </div>
                             <div class="col-12">
                                 <label class="text-muted extra-small text-uppercase fw-700">Medical Condition</label>
                                 <p class="small text-dark">{{ $report->medical_condition ?? 'None mentioned' }}</p>
                             </div>
                             <div class="col-12">
                                 <label class="text-muted extra-small text-uppercase fw-700">Identification Marks</label>
                                 <p class="small text-dark">{{ $report->identification_marks ?? 'None' }}</p>
                             </div>
                         </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card border-0 shadow-sm rounded-4 overflow-hidden">
            <div class="card-header bg-white py-3">
                <h6 class="fw-800 mb-0">FIR Document Preview</h6>
            </div>
            <div class="card-body p-4 text-center bg-light">
                @php $ext = pathinfo($report->fir_copy, PATHINFO_EXTENSION); @endphp
                @if(in_array(strtolower($ext), ['jpg','jpeg','png','webp']))
                    <img src="{{ asset('storage/' . $report->fir_copy) }}" class="img-fluid rounded-3 shadow-sm border" style="max-height: 800px;">
                @else
                    <div class="py-5">
                        <i class="fa-solid fa-file-pdf fa-4x text-danger mb-3"></i>
                        <p class="fw-700">PDF Document Attached</p>
                        <a href="{{ asset('storage/' . $report->fir_copy) }}" target="_blank" class="btn btn-primary rounded-pill px-4 shadow-sm">
                            <i class="fa-solid fa-download me-2"></i> Download FIR to Verify
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Verification Actions -->
    <div class="col-lg-4">
        <div class="card border-0 shadow-sm rounded-4 mb-4 bg-white sticky-top" style="top: 20px;">
            <div class="card-header bg-white py-3">
                <h6 class="fw-800 mb-0">Verification Panel</h6>
            </div>
            <div class="card-body p-4">
                <div class="alert {{ $report->fir_status == 'Verified' ? 'alert-success' : 'alert-warning' }} border-0 small mb-4">
                    <i class="fa-solid fa-circle-info me-2"></i>
                    <strong>Current:</strong> {{ $report->fir_status }}
                </div>

                <form action="{{ route('admin.reports.verify', $report->id) }}" method="POST">
                    @csrf
                    <div class="mb-3">
                        <label class="form-label small fw-700 text-muted">Verification Remarks</label>
                        <textarea name="remarks" class="form-control border-0 bg-light p-3 small" rows="4" placeholder="Mention why you are approving/rejecting...">{{ $report->verification_remarks }}</textarea>
                    </div>

                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-success rounded-pill py-2 fw-bold shadow-sm">
                            <i class="fa-solid fa-check-circle me-1"></i> Verify & Approve
                        </button>
                    </div>
                </form>

                <hr class="my-4">

                <form action="{{ route('admin.reports.reject', $report->id) }}" method="POST">
                    @csrf
                    <input type="hidden" name="remarks" id="reject_remarks">
                    <script>
                        document.forms[1].onsubmit = function() {
                            document.getElementById('reject_remarks').value = document.getElementsByName('remarks')[0].value;
                        }
                    </script>
                    <div class="d-grid">
                        <button type="submit" class="btn btn-outline-danger rounded-pill py-2 fw-bold" onclick="return confirm('Reject this report?')">
                            <i class="fa-solid fa-circle-xmark me-1"></i> Reject Report
                        </button>
                    </div>
                </form>

                <div class="mt-4 p-3 bg-light rounded-4 extra-small text-muted">
                    <div class="fw-700 text-dark mb-1">Checklist:</div>
                    <ul class="ps-3 mb-0">
                        <li>Photo is clear and identifiable.</li>
                        <li>FIR Stamp/Date matches details.</li>
                        <li>Reporter contact verified.</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .extra-small { font-size: 0.72rem; }
</style>
@endsection
