@extends('layouts.admin')

@section('admin_content')
<div class="row mb-4">
    <div class="col-8">
        <h4 class="fw-800 mb-0">Platform Settings</h4>
        <p class="text-muted small">Configure global platform behavior and limits.</p>
    </div>
</div>

<form action="{{ route('admin.settings.update') }}" method="POST">
    @csrf
    <div class="row g-4">
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm rounded-4 mb-4 overflow-hidden">
                <div class="card-header bg-white py-3 px-4">
                    <h6 class="fw-800 mb-0">General Configurations</h6>
                </div>
                <div class="card-body p-4">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label small fw-700">Platform Mode</label>
                            <select name="platform_mode" class="form-select border-0 bg-light p-3 small shadow-sm">
                                <option value="public" {{ ($settings['platform_mode'] ?? 'public') == 'public' ? 'selected' : '' }}>Public Submissions (Enabled)</option>
                                <option value="private" {{ ($settings['platform_mode'] ?? 'public') == 'private' ? 'selected' : '' }}>Private (Admin Only)</option>
                                <option value="maintenance" {{ ($settings['platform_mode'] ?? 'public') == 'maintenance' ? 'selected' : '' }}>Maintenance Mode</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label small fw-700">Max File Size (MB)</label>
                            <input type="number" name="max_upload_size" class="form-control border-0 bg-light p-3 small shadow-sm" value="{{ $settings['max_upload_size'] ?? '5' }}">
                        </div>
                        <div class="col-12">
                            <label class="form-label small fw-700">Allowed Document Formats</label>
                            <input type="text" name="allowed_formats" class="form-control border-0 bg-light p-3 small shadow-sm" value="{{ $settings['allowed_formats'] ?? 'jpg,png,pdf' }}" placeholder="Comma separated, e.g: jpg,png,pdf">
                        </div>
                        <div class="col-12">
                            <label class="form-label small fw-700">Emergency Helpline Links</label>
                            <input type="text" name="emergency_helpline" class="form-control border-0 bg-light p-3 small shadow-sm" value="{{ $settings['emergency_helpline'] ?? '100, 112, 1091' }}">
                        </div>
                    </div>
                </div>
            </div>

            <div class="card border-0 shadow-sm rounded-4 overflow-hidden">
                <div class="card-header bg-white py-3 px-4">
                    <h6 class="fw-800 mb-0">Security & Privacy Policy</h6>
                </div>
                <div class="card-body p-4">
                    <label class="form-label small fw-700">Privacy Policy Text</label>
                    <textarea name="privacy_policy" class="form-control border-0 bg-light p-4 small shadow-sm" rows="10">{{ $settings['privacy_policy'] ?? 'Platform privacy terms here...' }}</textarea>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card border-0 shadow-sm rounded-4 bg-primary text-white p-4 sticky-top" style="top: 20px;">
                <h5 class="fw-800 mb-3">Save Changes</h5>
                <p class="small opacity-75">Update these settings to apply changes globally across the Platform instantly.</p>
                <div class="d-grid mt-4">
                    <button type="submit" class="btn btn-white text-primary rounded-pill py-3 fw-bold shadow-sm">
                        <i class="fa-solid fa-cloud-arrow-up me-1"></i> Update Platform
                    </button>
                    <button type="reset" class="btn btn-link text-white text-decoration-none mt-2 extra-small opacity-50">Reset to Defaults</button>
                </div>
                
                <hr class="my-4 opacity-25">
                
                <div class="extra-small opacity-75">
                    <strong>Note:</strong> Changes in file sizes might require PHP.ini updates to take effect on the server level as well.
                </div>
            </div>
        </div>
    </div>
</form>

<style>
    .extra-small { font-size: 0.72rem; }
    .btn-white { background: white; color: var(--admin-primary); transition: all 0.2s; }
    .btn-white:hover { background: #f8fafc; transform: translateY(-2px); }
</style>
@endsection
