@extends('layouts.admin')

@section('admin_content')
<div class="row mb-4">
    <div class="col-8">
        <h4 class="fw-800 mb-0">User Management</h4>
        <p class="text-muted small">Manage platform users and their access.</p>
    </div>
</div>

<div class="table-card">
    <div class="table-responsive">
        <table class="table mb-0 align-middle">
            <thead>
                <tr>
                    <th class="ps-4">User Details</th>
                    <th>Email / Mobile</th>
                    <th>Role</th>
                    <th>Status</th>
                    <th>Joined</th>
                    <th class="text-end pe-4">Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($users as $user)
                <tr>
                    <td class="ps-4">
                        <div class="d-flex align-items-center">
                            <div class="rounded-circle bg-light d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                <i class="fa-solid fa-user text-muted small"></i>
                            </div>
                            <div>
                                <div class="fw-700 text-dark small">{{ $user->name }}</div>
                                <div class="extra-small text-muted">ID: #USR{{ str_pad($user->id, 4, '0', STR_PAD_LEFT) }}</div>
                            </div>
                        </div>
                    </td>
                    <td>
                        <div class="small fw-600 text-dark mb-0 line-height-1">{{ $user->email }}</div>
                        <div class="extra-small text-muted">{{ $user->mobile ?? 'No Mobile' }}</div>
                    </td>
                    <td>
                        <span class="badge {{ $user->is_admin ? 'bg-primary' : 'bg-light text-dark' }} px-3 py-2 rounded-pill extra-small">
                            {{ $user->role ?? ($user->is_admin ? 'Admin' : 'User') }}
                        </span>
                    </td>
                    <td>
                        @if($user->is_blocked)
                            <span class="badge bg-danger bg-opacity-10 text-danger px-3 py-2 rounded-pill extra-small">Blocked</span>
                        @else
                            <span class="badge bg-success bg-opacity-10 text-success px-3 py-2 rounded-pill extra-small">Active</span>
                        @endif
                    </td>
                    <td>
                        <div class="extra-small text-muted">{{ $user->created_at->format('M d, Y') }}</div>
                    </td>
                    <td class="text-end pe-4">
                        <div class="btn-group shadow-sm rounded-pill overflow-hidden border">
                            <a href="{{ route('admin.users.show', $user->id) }}" class="btn btn-white btn-sm border-0 px-3" title="View Profile">
                                <i class="fa-solid fa-eye text-primary"></i>
                            </a>
                            <form action="{{ route('admin.users.toggleBlock', $user->id) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-white btn-sm border-0 px-3" title="{{ $user->is_blocked ? 'Unblock' : 'Block' }}">
                                    @if($user->is_blocked)
                                        <i class="fa-solid fa-unlock text-success"></i>
                                    @else
                                        <i class="fa-solid fa-user-slash text-danger"></i>
                                    @endif
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <div class="card-footer bg-white py-3">
        {{ $users->links() }}
    </div>
</div>

<style>
    .line-height-1 { line-height: 1.2; }
    .extra-small { font-size: 0.7rem; }
</style>
@endsection
