@extends('layouts.app')

@section('content')
<div class="bg-soft min-vh-100 py-5">
    <div class="container pt-4">
        <div class="row">
            <!-- Sidebar Navigation -->
            <div class="col-lg-3 mb-4">
                <button class="btn btn-white w-100 d-lg-none shadow-sm border rounded-pill py-3 fw-800 mb-4 animate__animated animate__fadeIn" type="button" data-bs-toggle="collapse" data-bs-target="#dashboardMenu">
                    <i class="fa-solid fa-bars-staggered me-2 text-primary"></i> TERMINAL MENU
                </button>
                <div class="collapse d-lg-block" id="dashboardMenu">
                    @include('dashboard.partials.sidebar')
                </div>
            </div>

            <!-- Content Area -->
            <div class="col-lg-9 animate__animated animate__fadeIn">
                <div class="d-flex flex-column flex-sm-row justify-content-between align-items-sm-center mb-5 gap-4">
                    <div>
                        <h2 class="fw-800 mb-1">Station <span class="text-primary">Monitor.</span></h2>
                        <p class="text-secondary opacity-75 mb-0">Live status of your initiated search protocols.</p>
                    </div>
                    <a href="{{ url('/missing/create') }}" class="btn btn-premium px-4 py-3 d-flex align-items-center">
                        <i class="fa-solid fa-plus me-2"></i> NEW CASE FILING
                    </a>
                </div>

                @forelse($cases as $case)
                <div class="glass-card hover-lift p-0 overflow-hidden bg-white border-0 shadow-sm mb-4 border-start border-4 @if($case->status == 'Active') border-success @elseif($case->status == 'Resolved') border-secondary @else border-warning @endif">
                    <div class="card-body p-4">
                        <div class="row align-items-center g-4">
                            <div class="col-4 col-sm-2 col-md-1">
                                <div class="ratio ratio-1x1 rounded-3 overflow-hidden shadow-sm bg-light">
                                    @if($case->photo)
                                        <img src="{{ asset('storage/' . $case->photo) }}" class="object-fit-cover" alt="{{ $case->name }}">
                                    @else
                                        <div class="d-flex align-items-center justify-content-center h-100 opacity-25">
                                            <i class="fa-solid fa-user-large"></i>
                                        </div>
                                    @endif
                                </div>
                            </div>
                            <div class="col-8 col-sm-6 col-md-7">
                                <div class="d-flex flex-column flex-md-row align-items-md-center gap-2 mb-2">
                                    <h4 class="fw-800 text-dark mb-0">{{ $case->name }}</h4>
                                    <div class="vr bg-light d-none d-md-block" style="height: 15px;"></div>
                                    <div class="small fw-800 text-muted opacity-50">#ID-V{{ $case->id }}</div>
                                </div>
                                <div class="d-flex align-items-center gap-3 flex-wrap">
                                    <span class="small text-secondary fw-600">
                                        <i class="fa-solid fa-calendar-day me-1 opacity-50"></i> FILED: {{ $case->created_at->format('M d, Y') }}
                                    </span>
                                    
                                    @php
                                        $statusClass = match($case->status) {
                                            'Active' => 'bg-success',
                                            'Resolved' => 'bg-secondary',
                                            'Pending Verification' => 'bg-warning text-dark',
                                            default => 'bg-info'
                                        };
                                    @endphp
                                    
                                    <span class="badge {{ $statusClass }} bg-opacity-10 {{ $case->status == 'Pending Verification' ? 'text-dark' : 'text-'.str_replace('bg-', '', $statusClass) }} border border-opacity-10 px-3 py-2 rounded-pill fw-800 shadow-none" style="font-size: 0.65rem; letter-spacing: 0.5px;">
                                        <i class="fa-solid @if($case->status == 'Active') fa-circle-check @elseif($case->status == 'Resolved') fa-house-chimney-user @else fa-clock-rotate-left @endif me-1"></i>
                                        {{ strtoupper($case->status) }}
                                    </span>
                                </div>
                            </div>
                            <div class="col-12 col-sm-4 col-md-4 text-sm-end">
                                <div class="d-flex flex-column gap-2 align-items-sm-end">
                                    <a href="{{ route('dashboard.tips', $case->id) }}" class="btn btn-outline-premium btn-sm rounded-4 py-2 px-3 fw-800 d-flex align-items-center justify-content-center">
                                        LEADS CACHE <span class="badge bg-primary text-white ms-2 rounded-circle" style="font-size: 0.6rem;">{{ $case->tips_count }}</span>
                                    </a>
                                    
                                    <div class="dropdown">
                                        <button class="btn btn-light btn-sm dropdown-toggle rounded-4 py-2 px-4 border shadow-none fw-800 opacity-75 w-100" type="button" data-bs-toggle="dropdown">
                                            NODE ACTIONS
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-end border-0 shadow-lg animate__animated animate__fadeInUp animate__faster mt-2 py-2" style="border-radius: 16px;">
                                            <li><a class="dropdown-item py-2 fw-600" href="{{ route('missing.edit', $case->id) }}"><i class="fa-solid fa-pen-to-square me-2 text-primary opacity-50"></i> Edit Intelligence</a></li>
                                            @if($case->status != 'Resolved')
                                            <li>
                                                <form action="{{ route('missing.markFound', $case->id) }}" method="POST">
                                                    @csrf
                                                    <button type="submit" class="dropdown-item py-2 text-success fw-800"><i class="fa-solid fa-check-double me-2"></i> Mark Success (Found)</button>
                                                </form>
                                            </li>
                                            @endif
                                            <li><hr class="dropdown-divider opacity-50 mx-2"></li>
                                            <li>
                                                <form action="{{ route('missing.destroy', $case->id) }}" method="POST">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="dropdown-item py-2 text-danger fw-600" onclick="return confirm('Confirm complete erasure of case data?')"><i class="fa-solid fa-trash-can me-2 opacity-50"></i> Purge Data</button>
                                                </form>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @empty
                <div class="glass-card p-5 text-center bg-white border-0 shadow-sm animate__animated animate__zoomIn">
                    <div class="bg-light rounded-circle p-4 d-inline-block mb-4">
                        <i class="fa-solid fa-box-open text-primary opacity-25 fa-3x"></i>
                    </div>
                    <h4 class="fw-800 text-dark">Registry Empty</h4>
                    <p class="text-secondary opacity-75 mb-4">You have not initiated any search protocols from this node yet.</p>
                    <a href="{{ url('/missing/create') }}" class="btn btn-premium px-5 py-3 rounded-pill fw-800">START FIRST SEARCH</a>
                </div>
                @endforelse

            </div>
        </div>
    </div>
</div>
@endsection
