@extends('layouts.app')

@section('content')
<!-- Premium Hero Section -->
<section class="hero-section position-relative py-5 overflow-hidden d-flex align-items-center" style="min-height: 90vh;">
    <!-- Abstract Background Decor -->
    <div class="position-absolute translate-middle opacity-50 d-none d-lg-block" style="top: 20%; right: -5%; width: 600px; height: 600px; background: radial-gradient(circle, rgba(99, 102, 241, 0.2) 0%, transparent 70%); filter: blur(60px); z-index: 1;"></div>
    <div class="position-absolute translate-middle opacity-25 d-none d-lg-block" style="bottom: -10%; left: -5%; width: 500px; height: 500px; background: radial-gradient(circle, rgba(244, 63, 94, 0.2) 0%, transparent 70%); filter: blur(60px); z-index: 1;"></div>

    <div class="container position-relative z-index-2 animate__animated animate__fadeIn">
        <div class="row align-items-center g-5">
            <div class="col-lg-6 text-center text-lg-start">
                <div class="animate__animated animate__fadeInUp">
                    <span class="badge bg-primary bg-opacity-10 text-primary px-4 py-2 rounded-pill fw-bold mb-4 border border-primary border-opacity-20 letter-spacing-1 text-uppercase small">
                        <i class="fa-solid fa-earth-asia me-2"></i>Global Missing Registry
                    </span>
                    <h1 class="display-2 fw-800 mb-4 line-height-1" style="color: #0f172a;">
                        Hope Starts <br class="d-none d-md-block"> 
                        <span class="text-primary">With Connection.</span>
                    </h1>
                    <p class="lead text-secondary mb-5 fs-4" style="max-width: 550px; font-weight: 400;">
                        An ultra-secure, community-driven ecosystem designed to find, track, and reunite missing individuals with their families through verified intelligence.
                    </p>
                    <div class="d-flex flex-column flex-sm-row justify-content-center justify-content-lg-start gap-3">
                        <a href="{{ url('/missing/create') }}" class="btn btn-premium btn-lg px-5 py-3 d-flex align-items-center justify-content-center">
                            <i class="fa-solid fa-bullhorn me-3 fs-5"></i> File a Report
                        </a>
                        <a href="{{ url('/missing') }}" class="btn btn-outline-premium btn-lg px-5 py-3 d-flex align-items-center justify-content-center">
                            <i class="fa-solid fa-magnifying-glass me-3 fs-5"></i> Search Registry
                        </a>
                    </div>
                </div>
                
                <div class="mt-5 d-flex align-items-center justify-content-center justify-content-lg-start gap-4 opacity-75">
                    <div class="text-start">
                        <div class="h5 fw-800 mb-0 text-dark">500+</div>
                        <div class="small text-muted">Cases Filed</div>
                    </div>
                    <div class="vr mx-2 opacity-50" style="height: 30px;"></div>
                    <div class="text-start">
                        <div class="h5 fw-800 mb-0 text-dark">Verified</div>
                        <div class="small text-muted">By Authorities</div>
                    </div>
                    <div class="vr mx-2 opacity-50" style="height: 30px;"></div>
                    <div class="text-start">
                        <div class="h5 fw-800 mb-0 text-dark">Secure</div>
                        <div class="small text-muted">Encrypted Leads</div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-6 d-none d-lg-block animate__animated animate__zoomIn">
                <div class="position-relative">
                    <!-- Glassmorphism Card Stack -->
                    <div class="glass-card p-4 animate__animated animate__fadeInUp animate__delay-1s" style="width: 80%; transform: rotate(-5deg); position: relative; z-index: 3;">
                         <div class="d-flex align-items-center gap-3 mb-4">
                             <div class="rounded-circle bg-success shadow-sm" style="width: 12px; height: 12px;"></div>
                             <div class="h6 fw-800 mb-0">Active Search Intelligence</div>
                         </div>
                         <div class="p-3 bg-light rounded-4 mb-3 border border-white border-opacity-50">
                             <div class="small text-muted mb-1">Last Update</div>
                             <div class="fw-bold text-dark">Lead verified near Railway Station</div>
                         </div>
                         <div class="text-center">
                             <img src="https://images.unsplash.com/photo-1620641788421-7a1c342ea42e?q=80&w=2574&auto=format&fit=crop" class="rounded-4 img-fluid shadow-sm" style="height: 200px; width: 100%; object-fit: cover; opacity: 0.8;">
                         </div>
                    </div>
                    
                    <!-- Decorative Floating Elements -->
                    <div class="position-absolute top-50 start-50 translate-middle bg-primary rounded-circle opacity-5" style="width: 400px; height: 400px;"></div>
                    <div class="position-absolute top-0 end-0 bg-white rounded-4 shadow p-3 animate__animated animate__bounceIn" style="z-index: 4; transform: translate(20%, -20%);">
                         <i class="fa-solid fa-shield-check text-success fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Advanced Metrics / How it works -->
<section id="how-it-works" class="py-5 bg-white overflow-hidden">
    <div class="container py-5">
        <div class="row align-items-center mb-5">
            <div class="col-lg-5">
                <h2 class="display-5 fw-800 mb-3">Our Core <span class="text-primary">Ecosystem.</span></h2>
                <p class="text-secondary fs-5">We bridge the gap between reporting and recovery using a multi-channel alert system.</p>
            </div>
            <div class="col-lg-7 text-lg-end">
                <div class="d-flex flex-wrap justify-content-lg-end gap-2">
                    <span class="badge bg-light text-dark px-3 py-2 rounded-pill border">Real-time GPS Tracking</span>
                    <span class="badge bg-light text-dark px-3 py-2 rounded-pill border">Encrypted Leads</span>
                    <span class="badge bg-light text-dark px-3 py-2 rounded-pill border">Authority Integration</span>
                    <span class="badge bg-light text-dark px-3 py-2 rounded-pill border">Social Broadcasting</span>
                </div>
            </div>
        </div>
        
        <div class="row g-4 pt-4">
            <div class="col-md-4">
                <div class="glass-card hover-lift p-5 h-100 bg-white border-0">
                    <div class="bg-primary bg-opacity-10 rounded-4 d-flex align-items-center justify-content-center mb-4" style="width: 70px; height: 70px;">
                        <i class="fa-solid fa-file-shield text-primary fs-3"></i>
                    </div>
                    <h4 class="fw-800 mb-3">Report & Validated</h4>
                    <p class="text-secondary opacity-75 mb-0">Securely upload information. Our system validates FIR documents to ensure every report is genuine and actionable.</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="glass-card hover-lift p-5 h-100 bg-white border-0">
                    <div class="bg-accent bg-opacity-10 rounded-4 d-flex align-items-center justify-content-center mb-4" style="width: 70px; height: 70px;">
                        <i class="fa-solid fa-broadcast-tower text-accent fs-3"></i>
                    </div>
                    <h4 class="fw-800 mb-3">Broadcasting</h4>
                    <p class="text-secondary opacity-75 mb-0">Instantly generate digital missing posters and broadcast alerts across our community network for maximum visibility.</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="glass-card hover-lift p-5 h-100 bg-white border-0">
                    <div class="bg-success bg-opacity-10 rounded-4 d-flex align-items-center justify-content-center mb-4" style="width: 70px; height: 70px;">
                        <i class="fa-solid fa-handshake-angle text-success fs-3"></i>
                    </div>
                    <h4 class="fw-800 mb-3">Safe Recovery</h4>
                    <p class="text-secondary opacity-75 mb-0">Encrypted communication channel allows finders to share leads without compromising privacy, leading to safe reunions.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Active Cases Showcase -->
<section class="py-5 bg-soft">
    <div class="container py-5">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mb-5 gap-4">
            <div class="text-center text-md-start">
                <h2 class="display-5 fw-800 mb-2">Live Searches <span class="text-accent">Active.</span></h2>
                <p class="text-secondary mb-0">Every second counts. Your attention could save a life today.</p>
            </div>
            <a href="{{ url('/missing') }}" class="btn btn-outline-premium px-4 py-2">Explored All Matches <i class="fa-solid fa-arrow-right ms-2"></i></a>
        </div>
        
        <div class="row g-4">
            @forelse($recentCases as $case)
            <div class="col-md-6 col-lg-3">
                <div class="glass-card hover-lift p-0 overflow-hidden bg-white border-0 h-100 d-flex flex-column">
                    <div class="position-relative overflow-hidden" style="height: 280px;">
                        @if($case->photo)
                            <img src="{{ asset('storage/' . $case->photo) }}" class="w-100 h-100 object-fit-cover transition-img" alt="{{ $case->name }}" style="filter: grayscale(20%);">
                        @else
                            <div class="w-100 h-100 bg-light d-flex align-items-center justify-content-center">
                                <i class="fa-solid fa-user-large text-muted opacity-25 fa-3x"></i>
                            </div>
                        @endif
                        <div class="position-absolute top-0 end-0 p-3">
                             <div class="px-3 py-1 bg-accent text-white rounded-pill fw-bold" style="font-size: 0.65rem; border: 2px solid white;">ACTIVE SEARCH</div>
                        </div>
                        <div class="position-absolute bottom-0 start-0 w-100 p-3 bg-gradient-overlay d-flex justify-content-between align-items-center">
                             <span class="small text-white fw-600"><i class="fa-solid fa-location-dot me-1"></i> {{ Str::limit($case->last_seen_location, 15) }}</span>
                             <span class="small text-white fw-600 bg-black bg-opacity-50 px-2 py-1 rounded">{{ $case->age }} Yrs</span>
                        </div>
                    </div>
                    <div class="card-body p-4 flex-grow-1 d-flex flex-column">
                        <h5 class="fw-800 text-dark mb-2">{{ $case->name }}</h5>
                        <div class="small text-secondary opacity-75 mb-3">Missing since {{ $case->date_missing->format('M d, Y') }}</div>
                        <div class="mt-auto pt-3 border-top border-light d-flex justify-content-between align-items-center">
                             <a href="{{ route('missing.show', $case->id) }}" class="text-primary fw-bold text-decoration-none small">VIEW CASE FILE <i class="fa-solid fa-chevron-right ms-1"></i></a>
                             <div class="d-flex text-muted small"><i class="fa-solid fa-fingerprint me-1"></i> #{{ $case->id }}</div>
                        </div>
                    </div>
                </div>
            </div>
            @empty
            <div class="col-12 text-center py-5">
                <div class="p-5 bg-white rounded-5 shadow-sm">
                    <i class="fa-solid fa-magnifying-glass-plus text-primary opacity-25 fa-4x mb-4"></i>
                    <h5 class="fw-800 text-dark">No active cases reported yet.</h5>
                    <p class="text-muted">You can contribute by registering as a volunteer in your area.</p>
                </div>
            </div>
            @endforelse
        </div>
    </div>
</section>

<!-- Security Assurance -->
<section class="py-5 bg-dark position-relative overflow-hidden">
    <!-- Adjusted glow to be less intrusive on mobile -->
    <div class="position-absolute top-50 start-0 translate-middle-y bg-primary opacity-10 rounded-circle d-none d-lg-block" style="width: 300px; height: 300px; filter: blur(80px);"></div>
    
    <div class="container py-5">
        <div class="row g-5 align-items-center text-center text-lg-start">
            <div class="col-lg-8">
                <h3 class="display-6 fw-800 text-white mb-4 animate__animated animate__fadeInLeft">Protocol: Private & Secure.</h3>
                <p class="fs-5 mb-0 mx-auto mx-lg-0" style="max-width: 700px; color: #f8fafc; opacity: 0.9;">
                    We treat every case with extreme confidentiality. Reporter identities are encrypted, and leads are filtered through a multi-step verification process before being shared. We are built for trust.
                </p>
            </div>
            <div class="col-lg-4 text-center text-lg-end">
                <div class="d-inline-flex align-items-center gap-4 py-3 px-4 rounded-pill border border-white border-opacity-10 animate__animated animate__fadeInRight" style="background: rgba(255, 255, 255, 0.08); border: 1px solid rgba(255,255,255,0.2) !important;">
                    <i class="fa-solid fa-shield-halved text-primary fs-2"></i>
                    <div class="text-start">
                        <div class="text-white fw-bold mb-0">AES-256 Bit</div>
                        <div class="small fw-600" style="color: #cbd5e1;">Encrypted Platform</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
    .line-height-1 { line-height: 1.1; }
    .bg-gradient-overlay {
        background: linear-gradient(0deg, rgba(0,0,0,0.8) 0%, transparent 100%);
    }
    .img-fluid.transition-img {
        transition: transform 0.6s cubic-bezier(0.165, 0.84, 0.44, 1);
    }
    .hover-lift:hover .transition-img {
        transform: scale(1.1);
    }
    .bg-accent { background-color: var(--accent) !important; }
    .text-accent { color: var(--accent) !important; }
</style>
@endsection
