@extends('layouts.app')

@section('content')
<div class="bg-soft py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="d-flex align-items-center mb-4">
                    <a href="{{ url('/dashboard') }}" class="text-decoration-none text-muted small me-3"><i class="fa-solid fa-arrow-left"></i> Back</a>
                    <h2 class="fw-bold m-0">Edit Missing Person Report</h2>
                </div>
                
                <form method="POST" action="{{ route('missing.update', $missingPerson->id) }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    @if ($errors->any())
                        <div class="alert alert-danger border-0 shadow-sm mb-4">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    
                    <!-- Section 1: Reporter Info -->
                    <div class="card shadow-sm border-0 rounded-3 mb-4">
                        <div class="card-header bg-white py-3 border-bottom-0">
                            <h5 class="fw-bold text-primary m-0"><i class="fa-solid fa-user-shield me-2"></i>Reporter Information</h5>
                            <p class="text-muted small m-0">Your details remain private and are only for verification.</p>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">Relation with Missing Person <span class="text-danger">*</span></label>
                                    <select class="form-select bg-light border-0" name="relation" required>
                                        <option value="">Select Relation</option>
                                        <option value="Parent" {{ $missingPerson->relation == 'Parent' ? 'selected' : '' }}>Parent</option>
                                        <option value="Sibling" {{ $missingPerson->relation == 'Sibling' ? 'selected' : '' }}>Sibling</option>
                                        <option value="Spouse" {{ $missingPerson->relation == 'Spouse' ? 'selected' : '' }}>Spouse</option>
                                        <option value="Relative" {{ $missingPerson->relation == 'Relative' ? 'selected' : '' }}>Other Relative</option>
                                        <option value="Friend" {{ $missingPerson->relation == 'Friend' ? 'selected' : '' }}>Friend</option>
                                        <option value="Concerned Citizen" {{ $missingPerson->relation == 'Concerned Citizen' ? 'selected' : '' }}>Concerned Citizen</option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">Your Contact Number <span class="text-danger">*</span></label>
                                    <input type="tel" class="form-control bg-light border-0" name="reporter_contact" required value="{{ $missingPerson->reporter_contact }}">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">City <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control bg-light border-0" name="reporter_city" required value="{{ $missingPerson->reporter_city }}">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">State <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control bg-light border-0" name="reporter_state" required value="{{ $missingPerson->reporter_state }}">
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Section 2: Missing Person Details -->
                    <div class="card shadow-sm border-0 rounded-3 mb-4">
                        <div class="card-header bg-white py-3 border-bottom-0">
                            <h5 class="fw-bold text-primary m-0"><i class="fa-solid fa-user-injured me-2"></i>Missing Person Details</h5>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-12">
                                    <label class="form-label fw-medium small">Full Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control bg-light border-0" name="name" required value="{{ $missingPerson->name }}">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label fw-medium small">Age <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control bg-light border-0" name="age" required min="1" max="120" value="{{ $missingPerson->age }}">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label fw-medium small">Gender <span class="text-danger">*</span></label>
                                    <select class="form-select bg-light border-0" name="gender" required>
                                        <option value="">Select</option>
                                        <option value="Male" {{ $missingPerson->gender == 'Male' ? 'selected' : '' }}>Male</option>
                                        <option value="Female" {{ $missingPerson->gender == 'Female' ? 'selected' : '' }}>Female</option>
                                        <option value="Other" {{ $missingPerson->gender == 'Other' ? 'selected' : '' }}>Other</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label fw-medium small">Height (Approx)</label>
                                    <input type="text" class="form-control bg-light border-0" name="height" value="{{ $missingPerson->height }}">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">Complexion</label>
                                    <select class="form-select bg-light border-0" name="complexion">
                                        <option value="">Select</option>
                                        <option value="Fair" {{ $missingPerson->complexion == 'Fair' ? 'selected' : '' }}>Fair</option>
                                        <option value="Wheatish" {{ $missingPerson->complexion == 'Wheatish' ? 'selected' : '' }}>Wheatish</option>
                                        <option value="Dark" {{ $missingPerson->complexion == 'Dark' ? 'selected' : '' }}>Dark</option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">Language Spoken</label>
                                    <input type="text" class="form-control bg-light border-0" name="language" value="{{ $missingPerson->language }}">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">Date Missing <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control bg-light border-0" name="date_missing" required value="{{ $missingPerson->date_missing }}">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">Last Seen Location <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control bg-light border-0" name="last_seen_location" required value="{{ $missingPerson->last_seen_location }}">
                                </div>
                                <div class="col-12">
                                    <label class="form-label fw-medium small">Medical Condition (Optional)</label>
                                    <textarea class="form-control bg-light border-0" name="medical_condition" rows="2">{{ $missingPerson->medical_condition }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Section 3: Identification -->
                    <div class="card shadow-sm border-0 rounded-3 mb-4">
                        <div class="card-header bg-white py-3 border-bottom-0">
                            <h5 class="fw-bold text-primary m-0"><i class="fa-solid fa-id-card me-2"></i>Identification & Documents</h5>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">Recent Photograph</label>
                                    <input type="file" class="form-control" name="photo" accept="image/*">
                                    <div class="form-text small">Leave empty to keep current photo.</div>
                                    @if($missingPerson->photo)
                                        <img src="{{ asset('storage/' . $missingPerson->photo) }}" class="mt-2 rounded shadow-sm" style="height: 60px;">
                                    @endif
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">FIR Copy</label>
                                    <input type="file" class="form-control" name="fir_copy" accept=".pdf,image/*">
                                    <div class="form-text small">Leave empty to keep current FIR.</div>
                                    @if($missingPerson->fir_copy)
                                        <div class="mt-2 small text-muted"><i class="fa-solid fa-file-pdf"></i> FIR Attached</div>
                                    @endif
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">Birthmark / Scar / Tattoo</label>
                                    <input type="text" class="form-control bg-light border-0" name="identification_marks" value="{{ $missingPerson->identification_marks }}">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">Clothes Worn Last Time</label>
                                    <input type="text" class="form-control bg-light border-0" name="clothes" value="{{ $missingPerson->clothes }}">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <a href="{{ url('/dashboard') }}" class="btn btn-light me-md-2">Cancel</a>
                        <button type="submit" class="btn btn-primary px-5 py-2 fw-bold">Update Report</button>
                    </div>

                </form>
            </div>
        </div>
    </div>
</div>
@endsection
