@extends('layouts.app')

@section('content')
<div class="bg-soft py-5 min-vh-100">
    <div class="container pt-4">
        
        <!-- Header Section -->
        <div class="row align-items-end mb-5 g-4 text-center text-lg-start animate__animated animate__fadeIn">
            <div class="col-lg-8">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-2 d-none d-lg-flex">
                        <li class="breadcrumb-item"><a href="{{ url('/') }}" class="text-primary text-decoration-none small fw-bold">PROTOCOL</a></li>
                        <li class="breadcrumb-item active small fw-bold text-muted" aria-current="page">GLOBAL REGISTRY</li>
                    </ol>
                </nav>
                <h1 class="display-4 fw-800 mb-0">Active <span class="text-primary">Registry.</span></h1>
                <p class="text-secondary opacity-75 fs-5">Browsing verified missing person reports within the community network.</p>
            </div>
            <div class="col-lg-4 text-lg-end">
                <div class="p-3 bg-white shadow-sm rounded-4 d-inline-flex align-items-center gap-3 border border-light">
                    <div class="text-start">
                        <div class="small fw-bold text-muted text-uppercase letter-spacing-1" style="font-size: 0.65rem;">System Status</div>
                        <div class="text-success small fw-800"><i class="fa-solid fa-circle me-1 animate-pulse"></i> LIVE MONITORING</div>
                    </div>
                    <div class="vr bg-light" style="height: 30px;"></div>
                    <div class="h4 fw-800 mb-0 text-dark">{{ $missingPersons->total() }}</div>
                </div>
            </div>
        </div>

        <div class="row g-4">
            <!-- Advanced Sidebar Filters -->
            <div class="col-lg-3">
                <button class="btn btn-white w-100 d-lg-none shadow-sm border rounded-pill py-3 fw-bold mb-4" type="button" data-bs-toggle="collapse" data-bs-target="#advancedFilters">
                    <i class="fa-solid fa-sliders me-2"></i> Refine Intelligence
                </button>
                
                <div class="collapse d-lg-block sticky-top" id="advancedFilters" style="top: 100px; z-index: 10;">
                    <div class="glass-card p-4 border-0 shadow-sm animate__animated animate__fadeInLeft">
                        <div class="d-flex align-items-center justify-content-between mb-4">
                            <h5 class="fw-800 m-0">Parameters</h5>
                            <a href="{{ url('/missing') }}" class="text-primary small text-decoration-none fw-600">Reset</a>
                        </div>
                        
                        <form action="{{ url('/missing') }}" method="GET">
                            <div class="mb-4">
                                <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">Geo-Location</label>
                                <div class="position-relative">
                                    <i class="fa-solid fa-location-crosshairs position-absolute top-50 start-0 translate-middle-y ms-3 text-primary opacity-50"></i>
                                    <input type="text" class="form-control bg-light border-0 ps-5 py-2 fw-500" name="city" placeholder="City or landmark..." value="{{ request('city') }}">
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">Demographics</label>
                                <select class="form-select bg-light border-0 py-2 fw-500" name="gender">
                                    <option value="">Any Gender</option>
                                    <option value="Male" {{ request('gender') == 'Male' ? 'selected' : '' }}>Male</option>
                                    <option value="Female" {{ request('gender') == 'Female' ? 'selected' : '' }}>Female</option>
                                </select>
                            </div>

                            <div class="mb-4">
                                <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">Age Spectrum</label>
                                <div class="row g-2">
                                    <div class="col-6">
                                        <input type="number" class="form-control bg-light border-0 py-2 fw-500" name="min_age" placeholder="Min" value="{{ request('min_age') }}">
                                    </div>
                                    <div class="col-6">
                                        <input type="number" class="form-control bg-light border-0 py-2 fw-500" name="max_age" placeholder="Max" value="{{ request('max_age') }}">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="d-grid pt-3">
                                <button type="submit" class="btn btn-premium py-2">Execute Filter</button>
                            </div>
                        </form>
                    </div>

                    <!-- Safety Note -->
                    <div class="mt-4 p-4 bg-primary bg-opacity-10 rounded-4 border border-primary border-opacity-10 d-none d-lg-block">
                        <div class="d-flex gap-3 align-items-center mb-3 text-primary">
                            <i class="fa-solid fa-user-shield fs-4"></i>
                            <h6 class="fw-800 mb-0">Safety First</h6>
                        </div>
                        <p class="small text-dark opacity-75 mb-0">If you match a case, use the encrypted lead form on the case page. Do not attempt direct contact without reporting through platform.</p>
                    </div>
                </div>
            </div>

            <!-- Registry Grid -->
            <div class="col-lg-9 animate__animated animate__fadeInUp">
                <div class="row g-4">
                    @forelse($missingPersons as $person)
                    <div class="col-md-6 col-xl-4">
                        <div class="glass-card hover-lift p-0 overflow-hidden bg-white border-0 h-100 d-flex flex-column shadow-sm">
                            <div class="position-relative overflow-hidden" style="height: 300px;">
                                @if($person->photo)
                                    <img src="{{ asset('storage/' . $person->photo) }}" class="w-100 h-100 object-fit-cover transition-img" alt="{{ $person->name }}">
                                @else
                                    <div class="w-100 h-100 d-flex align-items-center justify-content-center bg-light text-muted">
                                        <div class="text-center">
                                            <i class="fa-solid fa-user-slash fa-3x opacity-25"></i>
                                            <div class="small mt-2 fw-bold opacity-50">NO IMAGE AVAILABLE</div>
                                        </div>
                                    </div>
                                @endif
                                
                                <div class="position-absolute top-0 start-0 m-3">
                                    <div class="bg-black bg-opacity-70 text-white px-3 py-1 rounded-pill small fw-800 shadow-sm" style="backdrop-filter: blur(5px);">
                                        <i class="fa-solid fa-fingerprint me-2 text-primary"></i>ID v{{ $person->id }}
                                    </div>
                                </div>

                                <div class="position-absolute top-0 end-0 m-3">
                                    <div class="bg-primary text-white rounded-4 p-2 shadow-lg d-flex flex-column align-items-center justify-content-center" style="width: 55px; height: 55px;">
                                        <span class="fw-800 mb-0 line-height-1">{{ $person->age }}</span>
                                        <span class="extra-small opacity-75 fw-bold">YRS</span>
                                    </div>
                                </div>

                                <div class="position-absolute bottom-0 start-0 w-100 p-4 bg-gradient-overlay d-flex flex-column">
                                    <div class="d-flex align-items-center gap-2 mb-1">
                                         <div class="bg-success rounded-circle animate-pulse" style="width: 8px; height: 8px;"></div>
                                         <span class="small text-white opacity-75 fw-bold text-uppercase letter-spacing-1">Verified Status</span>
                                    </div>
                                    <h4 class="text-white fw-800 mb-0 fs-5">{{ $person->name }}</h4>
                                </div>
                            </div>
                            
                            <div class="card-body p-4 flex-grow-1 d-flex flex-column">
                                <div class="p-3 bg-light rounded-4 mb-4 border border-light d-flex align-items-center">
                                    <i class="fa-solid fa-map-location-dot text-primary me-3 fs-5"></i>
                                    <div>
                                        <div class="small text-muted fw-800 text-uppercase letter-spacing-1" style="font-size: 0.6rem;">Last Detection</div>
                                        <div class="small fw-600 text-dark">{{ Str::limit($person->last_seen_location, 25) }}</div>
                                    </div>
                                </div>

                                <div class="mt-auto">
                                    <a href="{{ route('missing.show', $person->id) }}" class="btn btn-premium w-100 rounded-pill py-3 d-flex align-items-center justify-content-center">
                                        Open Case Intelligence <i class="fa-solid fa-arrow-right ms-2 fs-6"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    @empty
                    <div class="col-12 text-center py-5">
                        <div class="glass-card p-5 bg-white border-0 shadow-sm">
                            <i class="fa-solid fa-ghost fa-4x text-primary opacity-25 mb-4 d-block"></i>
                            <h4 class="fw-800">Intelligence Matrix Empty</h4>
                            <p class="text-secondary opacity-75 mb-4">No records found matching your specified parameters. Broaden your search or check again later.</p>
                            <a href="{{ url('/missing') }}" class="btn btn-outline-premium px-5 py-2">Clear Registry Filter</a>
                        </div>
                    </div>
                    @endforelse
                </div>

                <!-- Custom Pagination -->
                <div class="mt-5 d-flex justify-content-center">
                    {{ $missingPersons->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .bg-gradient-overlay {
        background: linear-gradient(0deg, rgba(0,0,0,0.9) 0%, rgba(0,0,0,0.4) 50%, transparent 100%);
    }
    .extra-small { font-size: 0.6rem; }
    .animate-pulse {
        animation: pulse 2s infinite;
    }
    @keyframes pulse {
        0% { transform: scale(1); opacity: 1; }
        50% { transform: scale(1.3); opacity: 0.5; }
        100% { transform: scale(1); opacity: 1; }
    }
    .letter-spacing-1 { letter-spacing: 1px; }
    .transition-img {
        transition: transform 0.8s cubic-bezier(0.165, 0.84, 0.44, 1);
    }
    .hover-lift:hover .transition-img {
        transform: scale(1.1);
    }
    .line-height-1 { line-height: 1; }
    
    /* Pagination Styler */
    .pagination .page-link {
        border-radius: 12px !important;
        margin: 0 4px;
        border: none;
        color: var(--secondary);
        font-weight: 600;
        box-shadow: 0 2px 5px rgba(0,0,0,0.05);
    }
    .pagination .page-item.active .page-link {
        background: var(--primary);
        color: white;
    }
</style>
@endsection
