<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MissingPersonController;
use App\Http\Controllers\TipController;
use App\Http\Controllers\DashboardController;

// Public Routes
Route::get('/', function () {
    $recentCases = \App\Models\MissingPerson::where('is_verified', true)
                                           ->where('status', 'Active')
                                           ->latest()
                                           ->limit(4)
                                           ->get();
    return view('home', compact('recentCases'));
})->name('home');

// Auth Routes
require __DIR__.'/auth.php';

// Protected Routes
Route::middleware(['auth'])->group(function () {
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard.index');
    Route::get('/dashboard/messages', [DashboardController::class, 'messages'])->name('dashboard.messages');
    Route::get('/dashboard/profile', [DashboardController::class, 'profile'])->name('dashboard.profile');
    Route::post('/dashboard/profile', [DashboardController::class, 'updateProfile'])->name('dashboard.profile.update');
    Route::get('/dashboard/cases/{id}/tips', [DashboardController::class, 'showTips'])->name('dashboard.tips');
    
    // Missing Person Management (Define specific routes before wildcard routes)
    Route::get('/missing/create', [MissingPersonController::class, 'create'])->name('missing.create');
    Route::post('/missing', [MissingPersonController::class, 'store'])->name('missing.store');
    Route::get('/missing/{id}/edit', [MissingPersonController::class, 'edit'])->name('missing.edit');
    Route::put('/missing/{id}', [MissingPersonController::class, 'update'])->name('missing.update');
    Route::post('/missing/{id}/mark-found', [MissingPersonController::class, 'markAsFound'])->name('missing.markFound');
    Route::delete('/missing/{id}', [MissingPersonController::class, 'destroy'])->name('missing.destroy');

    // Admin Group
    Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
        Route::get('/', [\App\Http\Controllers\AdminController::class, 'index'])->name('index');
        
        // User Management
        Route::get('/users', [\App\Http\Controllers\Admin\UserController::class, 'index'])->name('users.index');
        Route::get('/users/{id}', [\App\Http\Controllers\Admin\UserController::class, 'show'])->name('users.show');
        Route::post('/users/{id}/toggle-block', [\App\Http\Controllers\Admin\UserController::class, 'toggleBlock'])->name('users.toggleBlock');

        // Report Management
        Route::get('/reports', [\App\Http\Controllers\Admin\ReportController::class, 'index'])->name('reports.index');
        Route::get('/reports/{id}', [\App\Http\Controllers\Admin\ReportController::class, 'show'])->name('reports.show');
        Route::post('/reports/{id}/verify', [\App\Http\Controllers\Admin\ReportController::class, 'verify'])->name('reports.verify');
        Route::post('/reports/{id}/reject', [\App\Http\Controllers\Admin\ReportController::class, 'reject'])->name('reports.reject');
        Route::delete('/reports/{id}', [\App\Http\Controllers\Admin\ReportController::class, 'destroy'])->name('reports.destroy');

        // Message Monitoring
        Route::get('/messages', [\App\Http\Controllers\Admin\MessageController::class, 'index'])->name('messages.index');
        Route::delete('/messages/{id}', [\App\Http\Controllers\Admin\MessageController::class, 'destroy'])->name('messages.destroy');

        // Settings
        Route::get('/settings', [\App\Http\Controllers\Admin\SettingsController::class, 'index'])->name('settings.index');
        Route::post('/settings', [\App\Http\Controllers\Admin\SettingsController::class, 'update'])->name('settings.update');
    });
});

// Non-wildcard public routes
Route::get('/missing', [MissingPersonController::class, 'index'])->name('missing.index');

// Wildcard public routes (Must be at the bottom)
Route::get('/missing/{id}', [MissingPersonController::class, 'show'])->name('missing.show');

// Tip submission (public)
Route::post('/missing/{id}/tips', [TipController::class, 'store'])->name('tips.store');
