

<?php $__env->startSection('content'); ?>
<div class="auth-wrapper d-flex align-items-center justify-content-center min-vh-100 position-relative overflow-hidden py-5" style="background: #f8fafc;">
    <!-- Animated Blobs -->
    <div class="blob position-absolute bg-primary opacity-10 rounded-circle" style="width: 500px; height: 500px; top: -10%; right: -10%; filter: blur(100px); animation: float 20s infinite;"></div>
    <div class="blob position-absolute bg-accent opacity-10 rounded-circle" style="width: 400px; height: 400px; bottom: -5%; left: -5%; filter: blur(100px); animation: float 15s infinite reverse;"></div>

    <div class="container animate__animated animate__fadeIn">
        <div class="row justify-content-center">
            <div class="col-md-5">
                <div class="glass-card shadow-lg border-0 bg-white p-2" style="border-radius: 32px;">
                    <div class="card-body p-5">
                        <div class="text-center mb-5">
                            <div class="d-inline-flex align-items-center justify-content-center bg-primary bg-opacity-10 text-primary rounded-circle mb-4" style="width: 80px; height: 80px;">
                                <i class="fa-solid fa-lock-open-text fs-2"></i>
                            </div>
                            <h2 class="fw-800 text-dark mb-1">Access Protocol</h2>
                            <p class="text-secondary small fw-600 opacity-75">Establishing secure handshake with the network</p>
                        </div>

                        <form method="POST" action="<?php echo e(route('login')); ?>">
                            <?php echo csrf_field(); ?>

                            <?php if($errors->any()): ?>
                                <div class="p-3 bg-danger rounded-4 mb-4 animate__animated animate__shakeX">
                                    <div class="text-white small fw-800"><i class="fa-solid fa-circle-exclamation me-2"></i>Authentication Refused</div>
                                    <div class="text-white extra-small opacity-90 mt-1"><?php echo e($errors->first()); ?></div>
                                </div>
                            <?php endif; ?>

                            <div class="mb-4">
                                <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">INTELLIGENCE ID</label>
                                <div class="position-relative">
                                    <i class="fa-solid fa-at position-absolute top-50 start-0 translate-middle-y ms-3 text-primary opacity-50"></i>
                                    <input type="text" class="form-control bg-light border-0 ps-5 py-3 fw-600 rounded-4 shadow-none" name="email" required autofocus placeholder="Email or Username" style="color: #1e293b;">
                                </div>
                            </div>

                            <div class="mb-4">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-0">PASSPHRASE</label>
                                    <a class="text-primary small text-decoration-none fw-600" href="#">RESET KEYS</a>
                                </div>
                                <div class="position-relative">
                                    <i class="fa-solid fa-key position-absolute top-50 start-0 translate-middle-y ms-3 text-primary opacity-50"></i>
                                    <input type="password" class="form-control bg-light border-0 ps-5 py-3 fw-600 rounded-4 shadow-none" name="password" required placeholder="••••••••" style="color: #1e293b;">
                                </div>
                            </div>

                            <div class="mb-5 d-flex align-items-center justify-content-between">
                                <div class="form-check custom-check">
                                    <input type="checkbox" class="form-check-input shadow-none bg-transparent" id="remember" name="remember" style="width: 20px; height: 20px; border-radius: 6px; border-color: #cbd5e1;">
                                    <label class="form-check-label small text-secondary fw-600 ms-2" for="remember">Keep Persistent Session</label>
                                </div>
                            </div>

                            <div class="d-grid mb-4">
                                <button type="submit" class="btn btn-premium btn-lg py-3 fw-800 fs-5">
                                    INITIATE SESSION <i class="fa-solid fa-arrow-right-long ms-2"></i>
                                </button>
                            </div>

                            <!-- Redesigned Test Credentials Box -->
                            <div class="p-3 bg-light rounded-4 border border-2 border-dashed border-primary border-opacity-10">
                                <div class="d-flex align-items-center gap-2 mb-3">
                                    <div class="bg-primary bg-opacity-10 text-primary rounded-pill px-2 py-1">
                                        <i class="fa-solid fa-flask extra-small"></i>
                                    </div>
                                    <span class="extra-small fw-800 text-primary text-uppercase letter-spacing-1">Beta Handshake Nodes</span>
                                </div>
                                <div class="row g-3">
                                    <div class="col-6">
                                        <div class="extra-small fw-600 text-muted opacity-75 mb-1">USER ACCESS</div>
                                        <div class="small fw-800 text-dark">test@example.com</div>
                                    </div>
                                    <div class="col-6 border-start ps-3">
                                        <div class="extra-small fw-600 text-muted opacity-75 mb-1">ADMIN VAULT</div>
                                        <div class="small fw-800 text-dark">admin@example.com</div>
                                    </div>
                                    <div class="col-12 border-top border-light pt-2 text-center">
                                        <span class="extra-small fw-600 text-muted">MASTER PASSPHRASE: </span>
                                        <span class="small fw-800 text-primary">password</span>
                                    </div>
                                </div>
                            </div>

                            <div class="text-center">
                                <span class="text-secondary small fw-600">New Protocol Member?</span> 
                                <a href="<?php echo e(url('/register')); ?>" class="text-primary small fw-800 text-decoration-none ms-1">REQUEST ACCESS</a>
                            </div>
                        </form>
                    </div>
                </div>
                
                <div class="text-center mt-5 text-secondary animate__animated animate__fadeIn animate__delay-1s">
                    <div class="small fw-800 text-uppercase letter-spacing-1 opacity-50 mb-3">Community Trust Partners</div>
                    <div class="d-flex justify-content-center gap-4 grayscale opacity-50">
                        <i class="fa-solid fa-handshake-angle fs-4"></i>
                        <i class="fa-solid fa-user-shield fs-4"></i>
                        <i class="fa-solid fa-building-circle-check fs-4"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    @keyframes float {
        0%, 100% { transform: translate(0, 0); }
        50% { transform: translate(20px, 30px); }
    }
    .letter-spacing-1 { letter-spacing: 1px; }
    .extra-small { font-size: 0.65rem; }
    .grayscale { filter: grayscale(100%); }
    .custom-check .form-check-input:checked { background-color: var(--primary) !important; border-color: var(--primary) !important; }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\find\app\resources\views/auth/login.blade.php ENDPATH**/ ?>