

<?php $__env->startSection('admin_content'); ?>
<div class="row mb-4">
    <div class="col-8">
        <h4 class="fw-800 mb-0">Messages Monitoring</h4>
        <p class="text-muted small">Monitor tips and communications sent by finders.</p>
    </div>
</div>

<div class="table-card">
    <div class="table-responsive">
        <table class="table mb-0 align-middle">
            <thead>
                <tr>
                    <th class="ps-4">Sender / Contact</th>
                    <th>Linked Case</th>
                    <th>Message Content</th>
                    <th>Date / Time</th>
                    <th class="text-end pe-4">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="ps-4">
                        <div class="fw-700 text-dark small">Unknown Finder</div>
                        <div class="extra-small text-muted"><?php echo e($msg->contact_info ?? 'No Phone'); ?></div>
                    </td>
                    <td>
                        <a href="<?php echo e(route('admin.reports.show', $msg->missing_person_id)); ?>" class="text-decoration-none">
                            <span class="badge bg-light text-primary border rounded-pill extra-small">
                                <?php echo e($msg->missingPerson->name); ?>

                            </span>
                        </a>
                    </td>
                    <td>
                        <div class="p-3 bg-light rounded-3 small text-dark border-start border-4 border-info">
                            <?php echo e($msg->message); ?>

                        </div>
                    </td>
                    <td>
                        <div class="extra-small text-muted"><?php echo e($msg->created_at->format('M d, H:i')); ?></div>
                    </td>
                    <td class="text-end pe-4">
                        <div class="d-flex justify-content-end gap-2">
                            <form action="<?php echo e(route('admin.messages.destroy', $msg->id)); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-light-danger btn-sm rounded-pill p-2 border-0 bg-danger-soft" style="width: 32px; height: 32px;" title="Flag & Delete" onclick="return confirm('Spam detected? Delete message?')">
                                    <i class="fa-solid fa-trash-can text-danger"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" class="text-center py-5 text-muted small">No new tips/messages found.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <div class="card-footer bg-white py-3">
        <?php echo e($messages->links()); ?>

    </div>
</div>

<style>
    .extra-small { font-size: 0.72rem; }
    .bg-danger-soft { background: rgba(239, 68, 68, 0.1); }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\find\app\resources\views/admin/messages/index.blade.php ENDPATH**/ ?>