

<?php $__env->startSection('content'); ?>
<div class="bg-soft min-vh-100 py-5">
    <div class="container pt-4">
        <div class="row">
            <!-- Sidebar Navigation -->
            <div class="col-lg-3 mb-4">
                <button class="btn btn-white w-100 d-lg-none shadow-sm border rounded-pill py-3 fw-800 mb-4 animate__animated animate__fadeIn" type="button" data-bs-toggle="collapse" data-bs-target="#dashboardMenu">
                    <i class="fa-solid fa-bars-staggered me-2 text-primary"></i> TERMINAL MENU
                </button>
                <div class="collapse d-lg-block" id="dashboardMenu">
                    <?php echo $__env->make('dashboard.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
            </div>

            <!-- Content Area -->
            <div class="col-lg-9 animate__animated animate__fadeIn">
                <div class="glass-card overflow-hidden border-0 bg-white shadow-sm mb-4">
                    <div class="p-5 border-bottom border-light">
                        <h2 class="fw-800 mb-1">Intelligence <span class="text-primary">Cache.</span></h2>
                        <p class="text-secondary opacity-75 mb-0">Decentralized leads received from the community explorer network.</p>
                    </div>
                    
                    <div class="card-body p-0">
                        <!-- Desktop View: Sophisticated Table -->
                        <div class="table-responsive d-none d-md-block">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="bg-light bg-opacity-50">
                                    <tr>
                                        <th class="ps-5 py-4 small fw-800 text-muted text-uppercase letter-spacing-1">Case Profile</th>
                                        <th class="py-4 small fw-800 text-muted text-uppercase letter-spacing-1">Handshake Data</th>
                                        <th class="py-4 small fw-800 text-muted text-uppercase letter-spacing-1">Received</th>
                                        <th class="text-end pe-5 py-4 small fw-800 text-muted text-uppercase letter-spacing-1">Protocol</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $tips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr class="transition-all">
                                        <td class="ps-5 py-4">
                                            <div class="d-flex align-items-center">
                                                <div class="position-relative me-3">
                                                     <img src="<?php echo e(asset('storage/' . $tip->missingPerson->photo)); ?>" class="rounded-circle shadow-sm" style="width: 50px; height: 50px; object-fit: cover; border: 2px solid white;">
                                                     <div class="position-absolute bottom-0 end-0 bg-success rounded-circle border border-white" style="width: 12px; height: 12px;"></div>
                                                </div>
                                                <div>
                                                    <div class="fw-800 text-dark"><?php echo e($tip->missingPerson->name); ?></div>
                                                    <div class="extra-small text-primary fw-800">#ID-V<?php echo e($tip->missingPerson->id); ?></div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="py-4" style="max-width: 300px;">
                                            <div class="small fw-600 text-secondary mb-2 line-height-1-4 opacity-75">
                                                <?php echo e(Str::limit($tip->message, 80)); ?>

                                            </div>
                                            <?php if($tip->contact_info): ?>
                                                <div class="d-inline-flex align-items-center px-2 py-1 bg-primary bg-opacity-5 rounded-pill border border-primary border-opacity-10">
                                                    <i class="fa-solid fa-link text-primary extra-small me-2"></i>
                                                    <span class="extra-small fw-800 text-primary"><?php echo e($tip->contact_info); ?></span>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                        <td class="py-4">
                                            <div class="small fw-800 text-dark mb-0"><?php echo e($tip->created_at->diffForHumans()); ?></div>
                                            <div class="extra-small text-muted opacity-50 fw-600 text-uppercase"><?php echo e($tip->created_at->format('M d, H:i')); ?></div>
                                        </td>
                                        <td class="text-end pe-5 py-4">
                                            <a href="<?php echo e(route('dashboard.tips', $tip->missingPerson->id)); ?>" class="btn btn-outline-primary btn-sm rounded-pill px-4 fw-800 py-1 transition-all hover-fill">
                                                VERIFY
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="4" class="text-center py-5">
                                            <div class="py-5 opacity-25">
                                                <i class="fa-solid fa-satellite-dish fa-4x mb-4"></i>
                                                <h5 class="fw-800">No Intelligence Leads Detected</h5>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Mobile View: Premium Cards -->
                        <div class="d-md-none p-4">
                            <?php $__empty_1 = true; $__currentLoopData = $tips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="glass-card mb-4 bg-white border-0 shadow-sm p-4 animate__animated animate__fadeInUp">
                                <div class="d-flex align-items-center gap-3 mb-4">
                                     <img src="<?php echo e(asset('storage/' . $tip->missingPerson->photo)); ?>" class="rounded-4 shadow-sm" style="width: 60px; height: 60px; object-fit: cover;">
                                     <div>
                                         <h5 class="fw-800 mb-0"><?php echo e($tip->missingPerson->name); ?></h5>
                                         <div class="small text-primary fw-800">MEMORANDUM #<?php echo e($tip->missingPerson->id); ?></div>
                                     </div>
                                </div>
                                <div class="p-3 bg-light rounded-4 mb-4">
                                    <p class="small fw-600 text-secondary mb-0 opacity-75 line-height-1-5"><?php echo e($tip->message); ?></p>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="small fw-800 text-muted text-uppercase letter-spacing-1" style="font-size: 0.6rem;"><?php echo e($tip->created_at->diffForHumans()); ?></div>
                                    <a href="<?php echo e(route('dashboard.tips', $tip->missingPerson->id)); ?>" class="btn btn-premium btn-sm rounded-pill px-4 py-2">READ FULL FILE</a>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="text-center py-5 opacity-25">
                                <i class="fa-solid fa-ghost fa-3x mb-3"></i>
                                <div class="fw-800">Matrix Clear</div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .letter-spacing-1 { letter-spacing: 1px; }
    .extra-small { font-size: 0.65rem; }
    .line-height-1-4 { line-height: 1.4; }
    .line-height-1-5 { line-height: 1.5; }
    tr.transition-all:hover {
        background-color: rgba(99, 102, 241, 0.02);
    }
    .hover-fill:hover {
        background: var(--primary) !important;
        color: white !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\find\app\resources\views/dashboard/messages.blade.php ENDPATH**/ ?>