<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - FindMissing</title>
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --admin-primary: #6366f1;
            --admin-secondary: #4f46e5;
            --admin-bg: #f8fafc;
            --sidebar-bg: #1e293b;
            --sidebar-active: rgba(255, 255, 255, 0.1);
            --card-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }

        body {
            font-family: 'Plus Jakarta Sans', sans-serif;
            background-color: var(--admin-bg);
            color: #1e293b;
            margin: 0;
            padding: 0;
            overflow-x: hidden;
        }

        /* Sidebar Styling */
        .sidebar {
            width: 260px;
            height: 100vh;
            background-color: var(--sidebar-bg);
            position: fixed;
            left: 0;
            top: 0;
            z-index: 1000;
            transition: all 0.3s ease;
            color: white;
            padding: 1.5rem;
        }

        .sidebar-brand {
            font-size: 1.5rem;
            font-weight: 800;
            margin-bottom: 2.5rem;
            display: flex;
            align-items: center;
            color: white;
            text-decoration: none;
        }

        .sidebar-brand i {
            margin-right: 12px;
            color: var(--admin-primary);
        }

        .nav-label {
            font-size: 0.75rem;
            font-weight: 700;
            text-transform: uppercase;
            color: #94a3b8;
            margin-bottom: 1rem;
            letter-spacing: 0.05em;
        }

        .nav-link {
            display: flex;
            align-items: center;
            padding: 0.75rem 1rem;
            color: #94a3b8 !important;
            text-decoration: none;
            border-radius: 12px;
            margin-bottom: 0.5rem;
            transition: all 0.2s;
            font-weight: 500;
        }

        .nav-link:hover {
            background: var(--sidebar-active);
            color: white !important;
        }

        .nav-link.active {
            background: var(--admin-primary);
            color: white !important;
            box-shadow: 0 4px 12px rgba(99, 102, 241, 0.4);
        }

        .nav-link i {
            width: 20px;
            margin-right: 12px;
            font-size: 1.1rem;
        }

        /* Main Content */
        .main-content {
            margin-left: 260px;
            padding: 2rem;
            min-height: 100vh;
            transition: all 0.3s ease;
        }

        /* Top Header */
        .top-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid #e2e8f0;
        }

        .user-profile {
            display: flex;
            align-items: center;
            gap: 12px;
            background: white;
            padding: 6px 16px 6px 6px;
            border-radius: 50px;
            box-shadow: 0 4px 6px -1px rgba(0,0,0,0.05);
        }

        .user-avatar {
            width: 36px;
            height: 36px;
            background: var(--admin-primary);
            color: white;
            border-radius: 50px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
        }

        /* Widgets */
        .stat-card {
            background: white;
            border-radius: 20px;
            padding: 1.5rem;
            border: none;
            box-shadow: var(--card-shadow);
            transition: transform 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            position: relative;
            overflow: hidden;
        }

        .stat-card:hover {
            transform: translateY(-5px);
        }

        .stat-icon {
            width: 54px;
            height: 54px;
            border-radius: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            margin-bottom: 1rem;
        }

        .bg-primary-soft { background: rgba(99, 102, 241, 0.1); color: #6366f1; }
        .bg-success-soft { background: rgba(34, 197, 94, 0.1); color: #22c55e; }
        .bg-warning-soft { background: rgba(245, 158, 11, 0.1); color: #f59e0b; }
        .bg-danger-soft { background: rgba(239, 68, 68, 0.1); color: #ef4444; }

        /* Tables & Lists */
        .table-card {
            background: white;
            border-radius: 24px;
            box-shadow: var(--card-shadow);
            border: none;
            overflow: hidden;
        }

        .table thead th {
            background: #f8fafc;
            padding: 1.25rem 1rem;
            font-size: 0.75rem;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            color: #64748b;
            border-bottom: 2px solid #f1f5f9;
        }

        .table tbody td {
            padding: 1.25rem 1rem;
            border-bottom: 1px solid #f1f5f9;
            vertical-align: middle;
        }

        .badge-verified {
            background: #dcfce7;
            color: #166534;
            padding: 6px 12px;
            border-radius: 8px;
            font-weight: 600;
            font-size: 0.75rem;
        }

        .badge-pending {
            background: #fef9c3;
            color: #854d0e;
            padding: 6px 12px;
            border-radius: 8px;
            font-weight: 600;
            font-size: 0.75rem;
        }

        /* Glassmorphism elements */
        .glass-panel {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.4);
        }

        @media (max-width: 991.98px) {
            .sidebar { transform: translateX(-100%); }
            .main-content { margin-left: 0; }
        }
    </style>
</head>
<body>

    <!-- Sidebar -->
    <div class="sidebar">
        <a href="<?php echo e(url('/')); ?>" class="sidebar-brand">
            <i class="fa-solid fa-hands-holding-circle"></i>
            <span>FindMissing</span>
        </a>

        <div class="nav-label">Main Menu</div>
        <a href="<?php echo e(route('admin.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.index') ? 'active' : ''); ?>">
            <i class="fa-solid fa-gauge-high"></i>
            Dashboard
        </a>
        <a href="<?php echo e(route('admin.users.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.users.*') ? 'active' : ''); ?>">
            <i class="fa-solid fa-users"></i>
            User Management
        </a>
        <a href="<?php echo e(route('admin.reports.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.reports.*') ? 'active' : ''); ?>">
            <i class="fa-solid fa-file-invoice"></i>
            Reports Management
        </a>
        <a href="<?php echo e(route('admin.messages.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.messages.index') ? 'active' : ''); ?>">
            <i class="fa-solid fa-comments"></i>
            Messages Monitoring
        </a>
        <a href="<?php echo e(route('admin.settings.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.settings.index') ? 'active' : ''); ?>">
            <i class="fa-solid fa-gears"></i>
            Platform Settings
        </a>

        <div class="nav-label mt-5">Internal</div>
        <a href="<?php echo e(url('/dashboard')); ?>" class="nav-link">
            <i class="fa-solid fa-user-circle"></i>
            My Profile
        </a>
        
        <form action="<?php echo e(route('logout')); ?>" method="POST" class="mt-auto pt-5">
            <?php echo csrf_field(); ?>
            <button type="submit" class="nav-link border-0 bg-transparent w-100 text-start text-danger-emphasis">
                <i class="fa-solid fa-arrow-right-from-bracket"></i>
                Logout
            </button>
        </form>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Top Header -->
        <div class="top-header">
            <div>
                <h4 class="fw-800 mb-0">Overview</h4>
                <p class="text-muted small mb-0"><?php echo e(date('l, d F Y')); ?></p>
            </div>
            <div class="d-flex align-items-center gap-3">
                <button class="btn btn-white shadow-sm rounded-circle p-2 border-0" style="width: 40px; height: 40px;">
                    <i class="fa-solid fa-bell text-muted"></i>
                </button>
                <div class="user-profile">
                    <div class="user-avatar"><?php echo e(substr(Auth::user()->name, 0, 1)); ?></div>
                    <div class="small fw-700"><?php echo e(Auth::user()->name); ?></div>
                </div>
            </div>
        </div>

        <?php if(session('success')): ?>
            <div class="alert alert-success border-0 shadow-sm rounded-4 mb-4">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php echo $__env->yieldContent('admin_content'); ?>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH D:\find\app\resources\views/layouts/admin.blade.php ENDPATH**/ ?>