@extends('layouts.app')

@section('content')
<div class="container section-padding">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card shadow-lg border-0 rounded-4">
                <div class="card-body p-5">
                    <div class="text-center mb-4">
                         <h3 class="fw-bold text-primary">Create Account</h3>
                         <p class="text-muted small">Join the community to help others</p>
                    </div>

                    <form method="POST" action="{{ route('register') }}">
                        @csrf

                        <div class="mb-3">
                            <label for="name" class="form-label fw-medium small text-muted">Full Name</label>
                            <input type="text" class="form-control form-control-lg bg-light border-0" id="name" name="name" required placeholder="John Doe">
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="email" class="form-label fw-medium small text-muted">Email Address</label>
                                <input type="email" class="form-control form-control-lg bg-light border-0" id="email" name="email" required placeholder="name@example.com">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="mobile" class="form-label fw-medium small text-muted">Mobile Number</label>
                                <input type="tel" class="form-control form-control-lg bg-light border-0" id="mobile" name="mobile" required placeholder="9876543210">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="password" class="form-label fw-medium small text-muted">Password</label>
                                <input type="password" class="form-control form-control-lg bg-light border-0" id="password" name="password" required placeholder="********">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="password_confirmation" class="form-label fw-medium small text-muted">Confirm Password</label>
                                <input type="password" class="form-control form-control-lg bg-light border-0" id="password_confirmation" name="password_confirmation" required placeholder="********">
                            </div>
                        </div>

                        <div class="mb-4 form-check">
                            <input type="checkbox" class="form-check-input" id="declaration" required>
                            <label class="form-check-label small text-muted" for="declaration">
                                I confirm the information provided above is genuine and accurate.
                            </label>
                        </div>

                        <div class="d-grid mb-4">
                            <button type="submit" class="btn btn-primary btn-lg fw-bold">Register</button>
                        </div>

                        <div class="text-center small text-muted">
                            Already have an account? <a href="{{ url('/login') }}" class="fw-bold text-decoration-none">Login here</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
