@extends('layouts.app')

@section('content')
<div class="bg-soft min-vh-100 py-5">
    <div class="container">
        <div class="row">
            <!-- Sidebar Navigation (Optional for Dashboard) -->
            <div class="col-lg-3 mb-4">
                <div class="list-group shadow-sm border-0 rounded-3">
                    <a href="#" class="list-group-item list-group-item-action active border-0 py-3" aria-current="true">
                        <i class="fa-solid fa-list-check me-2"></i> My Reported Cases
                    </a>
                    <a href="#" class="list-group-item list-group-item-action border-0 py-3">
                        <i class="fa-solid fa-envelope me-2"></i> Messages <span class="badge bg-danger rounded-pill float-end">3</span>
                    </a>
                    <a href="#" class="list-group-item list-group-item-action border-0 py-3">
                        <i class="fa-solid fa-user me-2"></i> Profile Settings
                    </a>
                </div>
            </div>

            <!-- Content Area -->
            <div class="col-lg-9">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="fw-bold m-0">My Reported Cases</h3>
                    <a href="{{ url('/missing/create') }}" class="btn btn-primary btn-sm"><i class="fa-solid fa-plus me-1"></i> New Report</a>
                </div>

                <!-- Case Card 1 -->
                <div class="card shadow-sm border-0 rounded-3 mb-3">
                    <div class="card-body p-4">
                        <div class="row align-items-center">
                            <div class="col-md-2">
                                <div class="bg-light rounded d-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                                    <i class="fa-solid fa-image text-muted"></i>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <h5 class="fw-bold mb-1">Jane Doe</h5>
                                <p class="text-muted small mb-1">Reported on: Jan 15, 2024</p>
                                <span class="badge bg-success bg-opacity-10 text-success border border-success border-opacity-25 rounded-pill">Active</span>
                            </div>
                            <div class="col-md-4 text-md-end mt-3 mt-md-0">
                                <button class="btn btn-outline-primary btn-sm me-2" data-bs-toggle="modal" data-bs-target="#messagesModal">
                                    <i class="fa-solid fa-envelope me-1"></i> View Messages (2)
                                </button>
                                <div class="dropdown d-inline-block">
                                    <button class="btn btn-light btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                        Actions
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-end border-0 shadow">
                                        <li><a class="dropdown-item" href="#"><i class="fa-solid fa-pen me-2"></i> Edit Details</a></li>
                                        <li><a class="dropdown-item text-success" href="#"><i class="fa-solid fa-check me-2"></i> Mark as Found</a></li>
                                        <li><hr class="dropdown-divider"></li>
                                        <li><a class="dropdown-item text-danger" href="#"><i class="fa-solid fa-trash me-2"></i> Delete</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Case Card 2 (In-Active) -->
                 <div class="card shadow-sm border-0 rounded-3 mb-3 opacity-75">
                    <div class="card-body p-4">
                        <div class="row align-items-center">
                            <div class="col-md-2">
                                <div class="bg-light rounded d-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                                    <i class="fa-solid fa-image text-muted"></i>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <h5 class="fw-bold mb-1">Rahul Kumar</h5>
                                <p class="text-muted small mb-1">Reported on: Dec 10, 2023</p>
                                <span class="badge bg-secondary rounded-pill">Resolved / Found</span>
                            </div>
                            <div class="col-md-4 text-md-end mt-3 mt-md-0">
                                <button class="btn btn-outline-secondary btn-sm disabled" width="100%">Case Closed</button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<!-- Messages Modal Mockup -->
<div class="modal fade" id="messagesModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content rounded-4 border-0">
            <div class="modal-header border-bottom-0">
                <h5 class="modal-title fw-bold">Tips Received for Jane Doe</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-0">
                <div class="list-group list-group-flush">
                    <div class="list-group-item p-4">
                        <div class="d-flex w-100 justify-content-between mb-2">
                            <h6 class="mb-1 fw-bold">Anonymous Finder</h6>
                            <small class="text-muted">3 days ago</small>
                        </div>
                        <p class="mb-1 text-muted small">I think I saw a girl matching this description near the connaught place metro station exit 2.</p>
                        <small class="text-primary fw-medium cursor-pointer">Reply</small>
                    </div>
                     <div class="list-group-item p-4 bg-light">
                        <div class="d-flex w-100 justify-content-between mb-2">
                            <h6 class="mb-1 fw-bold">Concerned Citizen</h6>
                            <small class="text-muted">1 week ago</small>
                        </div>
                        <p class="mb-1 text-muted small">Checking if this is similar to the news report I saw yesterday...</p>
                        <small class="text-primary fw-medium cursor-pointer">Reply</small>
                    </div>
                </div>
            </div>
            <div class="modal-footer border-top-0">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection
