<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Help Reunite Missing People With Their Families - A Community Driven Platform">
    <title>@yield('title', 'FindMissing - Reuniting Families')</title>
    
    <!-- Google Fonts: Inter for Clean, Professional Look -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom CSS -->
    <link href="{{ asset('css/style.css') }}" rel="stylesheet">

    <!-- CSS Placeholder for raw HTML preview without Laravel asset helper -->
    <style>
        :root {
            --primary-color: #0F52BA; /* Sapphire Blue - Trust */
            --secondary-color: #6c757d;
            --accent-bg: #F8F9FA;
            --text-dark: #2C3E50;
            --text-muted: #6c757d;
            --border-radius: 8px;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background-color: #FDFDFD;
            color: var(--text-dark);
            -webkit-font-smoothing: antialiased;
        }

        /* Navigation */
        .navbar {
            background-color: #ffffff;
            box-shadow: 0 2px 15px rgba(0,0,0,0.04);
            padding: 1rem 0;
        }
        
        .navbar-brand {
            font-weight: 700;
            color: var(--primary-color) !important;
            font-size: 1.5rem;
            letter-spacing: -0.5px;
        }
        
        .nav-link {
            font-weight: 500;
            color: var(--text-dark);
            margin-left: 1rem;
            transition: color 0.2s;
        }
        
        .nav-link:hover, .nav-link.active {
            color: var(--primary-color);
        }

        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            padding: 0.6rem 1.5rem;
            font-weight: 500;
            border-radius: var(--border-radius);
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            background-color: #0a3d8f;
            border-color: #0a3d8f;
            transform: translateY(-1px);
        }

        .btn-outline-primary {
            color: var(--primary-color);
            border-color: var(--primary-color);
            border-radius: var(--border-radius);
            padding: 0.6rem 1.5rem;
            font-weight: 500;
        }
        
        .btn-outline-primary:hover {
            background-color: var(--primary-color);
            color: white;
        }

        /* Cards */
        .card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.03);
            transition: transform 0.2s, box-shadow 0.2s;
            overflow: hidden;
            background: white;
        }
        
        .card:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.06);
        }

        /* Footer */
        .footer {
            background-color: #2C3E50;
            color: white;
            padding: 4rem 0 2rem;
            margin-top: auto;
        }
        
        .footer a {
            color: rgba(255,255,255,0.7);
            text-decoration: none;
            transition: color 0.2s;
        }
        
        .footer a:hover {
            color: white;
        }

        /* Utilities */
        .section-padding {
            padding: 5rem 0;
        }
        
        .bg-soft {
            background-color: #F8F9FA;
        }

        main {
            min-height: 80vh;
        }
    </style>
</head>
<body class="d-flex flex-column min-vh-100">

    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg sticky-top">
        <div class="container">
            <a class="navbar-brand" href="{{ url('/') }}">
                <i class="fa-solid fa-hands-holding-circle me-2"></i>FindMissing
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item">
                        <a class="nav-link {{ request()->is('/') ? 'active' : '' }}" href="{{ url('/') }}">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ request()->is('missing') ? 'active' : '' }}" href="{{ url('/missing') }}">Details of Missing Persons</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ request()->is('how-it-works') ? 'active' : '' }}" href="#how-it-works">How it Works</a>
                    </li>
                    @auth
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                                {{ Auth::user()->name ?? 'Account' }}
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end border-0 shadow">
                                <li><a class="dropdown-item" href="{{ url('/dashboard') }}">Dashboard</a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li>
                                    <form method="POST" action="{{ route('logout') }}">
                                        @csrf
                                        <button type="submit" class="dropdown-item text-danger">Logout</button>
                                    </form>
                                </li>
                            </ul>
                        </li>
                        <li class="nav-item ms-lg-3">
                             <a class="btn btn-primary btn-sm" href="{{ url('/missing/create') }}">Report Missing</a>
                        </li>
                    @else
                        <li class="nav-item ms-lg-3">
                            <a class="btn btn-outline-primary btn-sm me-2" href="{{ url('/login') }}">Login</a>
                        </li>
                        <li class="nav-item">
                            <a class="btn btn-primary btn-sm" href="{{ url('/register') }}">Register</a>
                        </li>
                    @endauth
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main>
        @yield('content')
    </main>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row g-4">
                <div class="col-lg-4 col-md-6">
                    <h5 class="mb-4 fw-bold">FindMissing</h5>
                    <p class="text-white-50">A community-driven platform to help reunite missing persons with their families safely and securely.</p>
                </div>
                <div class="col-lg-2 col-md-6">
                    <h6 class="text-uppercase mb-3 fw-bold">Quick Links</h6>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="{{ url('/') }}">Home</a></li>
                        <li class="mb-2"><a href="{{ url('/missing') }}">Search</a></li>
                        <li class="mb-2"><a href="{{ url('/missing/create') }}">Report Case</a></li>
                    </ul>
                </div>
                <div class="col-lg-2 col-md-6">
                    <h6 class="text-uppercase mb-3 fw-bold">Support</h6>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="#">Safety Tips</a></li>
                        <li class="mb-2"><a href="#">Privacy Policy</a></li>
                        <li class="mb-2"><a href="#">Contact NGO</a></li>
                    </ul>
                </div>
                <div class="col-lg-4 col-md-6">
                    <h6 class="text-uppercase mb-3 fw-bold">Emergency Contact</h6>
                    <p class="text-white-50"><i class="fa-solid fa-phone me-2"></i> 1090 (Women Helpline)</p>
                    <p class="text-white-50"><i class="fa-solid fa-phone me-2"></i> 100 (Police)</p>
                </div>
            </div>
            <hr class="my-4 border-light opacity-10">
            <div class="text-center text-white-50 small">
                &copy; {{ date('Y') }} FindMissing. All rights reserved. Not a government agency.
            </div>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="//unpkg.com/alpinejs" defer></script>
</body>
</html>
